function [AR,Om] = do_LPIV_ARtest(LPIV,IRFnull,nvar)

yy      = LPIV.vars(LPIV.p+1:end,nvar);                    % outcome variables
%if isempty(LPIV.varsy)
YY      = LPIV.vars(LPIV.p+1:end,1);                    % endogenous regressor
%else
%YY      = LPIV.varsy(LPIV.p+1:end,1);                    % endogenous regressor
%end  
XX      = lagmatrix(LPIV.vars,1:LPIV.p);
XX      = [XX(LPIV.p+1:end,:) LPIV.DET(LPIV.p+1:end,:)]; % controls
ZZ      = LPIV.taxshocks(LPIV.p+1:end,:);              % instruments

[LPIV.T,~] = size(yy);

AR = zeros(size(IRFnull))';

for h = 0:LPIV.irhor-1
    y = yy((1+h):end, :); %y_{t+h}, t=1,...,T-h
    Y = YY(1:(end-h), :); %Y_t      t=1,...,T-h
    X = XX(1:(end-h), :); %X_t      t=1,...,T-h
    % omit RHS regressor without variability other than constant: 
        varX = var(X);
        X(:,[varX(:,1:end-1) 1]<eps)=[];

    Z = ZZ(1:(end-h), :); %z_t      t=1,...,T-h

    coeffs1   = ([X';Z']*[X,Z])\([X';Z']*y);
    coeffs2   = ([X';Z']*[X,Z])\([X';Z']*Y);
    
    M = eye((LPIV.T-h))-X*((X'*X)\X');

    for nn= 1:length(IRFnull(1+h,:))
        AR(nn,1+h)= ((LPIV.T-h)^.5*(coeffs1(end)-IRFnull(1+h,nn)*coeffs2(end)))^2; % STATA version
    end
    u           = Y-[X,Z]*(([X';Z']*[X,Z])\([X';Z']*Y)); 
    v           = y-[X,Z]*(([X';Z']*[X,Z])\([X';Z']*y));
    XXp           = (X'*X)./(LPIV.T-h);
    ZXp           = (Z'*X)./(LPIV.T-h);
    A             = [ -(ZXp)*((XXp)\eye(size(XXp,1))), 1 , zeros(1,size(XXp,1)), 0 ; ...
                       zeros(1,size(XXp,1))   , 0 , -(ZXp)*((XXp)\eye(size(XXp,1))),1];
    ZMZp          = (Z'*M*Z/(LPIV.T-h));
    W             = NW_hac_STATA([X.*v,Z.*v,X.*u, Z.*u],LPIV.NWlags);
    Om(:,:,1+h)   = A*W*A'./(ZMZp^2);
end

